
-- 177, Dates

SELECT SYSDATETIME()       AS "maintenant",
       SYSDATETIMEOFFSET() AS "decalage_greenwich",
       SYSUTCDATETIME()    AS "maintenant_TU";

SELECT CURRENT_TIMESTAMP AS "maintenant",
       GETDATE()         AS "maintenant",
       GETUTCDATE()      AS "maintenant_TU";

-- 178, ISO


USE BD_Air_France;

IF OBJECT_ID ('dbo.T_vols_historique_vlh','U') IS NOT NULL
    DROP TABLE dbo.T_vols_historique_vlh;
GO
CREATE TABLE T_vols_historique_vlh
(vlh_num_vol  VARCHAR(8),
 vlh_creation         DATE       NOT NULL,
 vlh_fin_exploitation DATETIME2,
 vlh_h_dep            TIME(0),
 vlh_h_arr            TIME(0),
 aer_dep              VARCHAR(3) NOT NULL,
 aer_arr              VARCHAR(3) NOT NULL,
 CONSTRAINT  PK_vlh         PRIMARY KEY(vlh_num_vol,vlh_creation));
GO

INSERT INTO T_vols_historique_vlh
 (vlh_num_vol,vlh_creation,vlh_fin_exploitation,vlh_h_dep,vlh_h_arr,aer_dep,aer_arr)
VALUES 
 ('AF6140','19651025','19981220 15:45:00','12:35:00','13:55:00','TLS','ORY');

SET DATEFORMAT dmy;

INSERT INTO T_vols_historique_vlh
(vlh_num_vol,vlh_creation,vlh_fin_exploitation,vlh_h_dep,vlh_h_arr,aer_dep,aer_arr)
VALUES 
 ('AF6145','15/02/1995','15-02-2005 15:00:00','12:30:00','13:45:00','TLS','CDG');

SET DATEFORMAT MDY;
INSERT INTO T_vols_historique_vlh
(vlh_num_vol,vlh_creation,vlh_fin_exploitation,vlh_h_dep,vlh_h_arr,aer_dep,aer_arr)
VALUES 
 ('AF6147','05/13/1995','07/27/2006 21:30:00','20:30:00','21:45:00','NIC','CDG');


-- 178

SELECT CAST('490420' AS DATETIME2)     AS "Siecle en cours",
       CAST('490212' AS SMALLDATETIME) AS "Siecle en cours",
       CAST('791124' AS DATE)          AS "Siecle pass",
       CAST('500420' AS DATETIME2)     AS "Siecle pass";

--  pour changer le sicle

USE master;
EXEC sp_configure 'show advanced option', '1';
RECONFIGURE;
GO
EXEC sp_configure 'two digit year cutoff', 'xx49';
RECONFIGURE;
GO

-- 180, construire des dates

SELECT CAST('15/02/2005 12:32:10.00 +01:00' AS DATETIMEOFFSET) AS "DATETIMEOFFSET",
       CAST('15/02/2005' AS DATETIME2) AS "DATETIME2",
       CAST('15-02-2005' AS SMALLDATETIME) AS "SMALLDATETIME",
       CAST('15.02.2005' AS DATE) AS "DATE";

-- 181, format interne

SELECT CONVERT(VARBINARY(MAX), CAST('2012/05/06' AS DATETIME2)) AS "Dbut de la journe...",
       CONVERT(VARBINARY(MAX), CAST('2012/05/06 20:00:00' AS DATETIME2)) AS "Le prsident est...";


-- 182, constructeurs

USE    BD_Air_France;
SELECT DATEFROMPARTS          (1965,02,05)                    AS dat_d1,
       SMALLDATETIMEFROMPARTS (1965,02,05,6,30)               AS dat_d2,
       DATETIME2FROMPARTS     (1965,02,05,6,30,0,1276,4)      AS dat_d3,
       DATETIMEOFFSETFROMPARTS(1965,02,05,6,30,0,1276,+1,0,4) AS dat_d4
INTO   T_date_naissance_dat;

DROP TABLE T_date_naissance_dat;

-- parties

-- 184, DATENAME

USE    BD_Air_France;
SELECT vlh_num_vol, 
       DATENAME(weekday,vlh_creation) AS "Jour dbut exploitation",
       DATENAME(month,vlh_creation)   AS "Mois dbut exploitation",
	   vlh_creation
FROM   T_vols_historique_vlh;

SELECT
DATENAME(hour,SYSDATETIME()) AS "Heure",
DATENAME(minute,SYSDATETIME()) AS "Minute",
DATENAME(second,SYSDATETIME()) AS "Seconde",
DATENAME(millisecond,SYSDATETIME()) AS "Mili seconde",
DATENAME(microsecond, SYSDATETIME()) AS "Micro seconde",
DATENAME(nanosecond, SYSDATETIME()) AS "Nano seconde"
INTO T_le_changement_c_maintenant;

-- 185

SELECT
DATENAME(year,SYSDATETIME()) AS "Anne",
DATENAME(quarter,SYSDATETIME()) AS "Trimestre",
DATENAME(month,SYSDATETIME())  AS "Mois",
DATENAME(dayofyear,SYSDATETIME()) AS "Jour anne",
DATENAME(day,SYSDATETIME()) AS "Jour",
DATENAME(ISO_WEEK,SYSDATETIME()) AS "Semaine",
DATENAME(weekday,SYSDATETIME())  AS "Jour de semaine";

-- 185, DATEPART

USE     BD_Air_France;
SELECT  vlh_num_vol, vlh_creation, vlh_fin_exploitation
FROM    T_vols_historique_vlh
WHERE   DATEPART(quarter,vlh_fin_exploitation) > 2;

--  185, DATEADD 

USE     BD_Air_France;
SELECT  vlh_num_vol, vlh_creation, vlh_fin_exploitation,
        DATEADD(minute,15,(DATEADD(hour,1,DATEADD(day,1,vlh_fin_exploitation))))
FROM    T_vols_historique_vlh;

-- 186

SELECT DATEADD(day,-2000,DATEADD(month,-200,DATEADD(year,-20,SYSDATETIME())))
       AS "20 ans 200 mois et 2000 jours avant maintenant";

SELECT DATEADD(second,2147483647,SYSDATETIME());


-- 187, intervalles DATEDIFF 

USE      BD_Air_France;
SELECT   vlh_num_vol, vlh_creation, vlh_fin_exploitation,
         DATEDIFF(day,vlh_creation,vlh_fin_exploitation) AS "Nombre de jours"
FROM     T_vols_historique_vlh
ORDER BY 4;

-- 

DECLARE @d1 DATETIME2;
DECLARE @d2 DATETIME2;

SET @d1 = '2012-10-10 01:18:58';
SET @d2 = '2012-10-14 03:10:01';

SELECT DATEDIFF(day   ,@d1,@d2) AS "j",       DATEDIFF(hour  ,@d1,@d2) AS "h",
       DATEDIFF(minute,@d1,@d2) AS "min",     DATEDIFF(second,@d1,@d2) AS "sec.";


-- d1 plus petite que d2

DECLARE @d1 DATETIME2;
DECLARE @d2 DATETIME2;

-- SQL Server est Charlie

SET @d1 = '2015-01-07 11:29:58';
SET @d2 = (SELECT GETDATE());

SELECT  DATEDIFF(second,@d1,@d2)                           AS "difference en secondes",
        DATEDIFF(second,@d1,@d2)/(24*60*60)                AS "jours",
        (DATEDIFF(second,@d1,@d2)%(24*60*60))/(60*60)      AS "heures",
        ((DATEDIFF(second,@d1,@d2)%(24*60*60))%(60*60))/60 AS "minutes",
        ((DATEDIFF(second,@d1,@d2)%(24*60*60))%(60*60))%60 AS "secondes";

-- 188, heures

USE    BD_Air_France;
SELECT TIMEFROMPARTS (15,54,23,0,0)  AS heu_t1,
       TIMEFROMPARTS (15,54,23,1,2)  AS heu_t2,
       TIMEFROMPARTS (15,54,23,78,4) AS heu_t3
INTO   T_heures_heu;

-- ajout 

SELECT *
FROM   T_heures_heu;

SELECT heu_t1,
       DATEADD(hour,10,heu_t1)      AS "+ 10 heures",
       DATEADD(minute,214,heu_t1)   AS "+ 214 minutes (3 h. 34 min.)",
       DATEADD(second,18337,heu_t1) AS "+ 18337 secondes (5 h. 5 min. 37 sec.)"
FROM   T_heures_heu;

-- soustraire 

SELECT heu_t1,
       DATEADD(hour,-10,heu_t1)      AS "- 10 heures",
       DATEADD(minute,-214,heu_t1)   AS "- 214 minutes (3 h. 34 min.)",
       DATEADD(second,-18337,heu_t1) AS "- 18337 secondes (5 h. 5 min. 37 sec.)"
FROM   T_heures_heu;

-- 189, dure entre les vols diff

USE      BD_Air_France;
SELECT   vlh_num_vol AS "Vol", aer_dep AS "Dpart", aer_arr AS "Arrive",
         DATEDIFF(minute,vlh_h_dep,vlh_h_arr) AS "Temps du vol (min.)"
FROM     T_vols_historique_vlh;

-- 189, mises  jour 

USE      BD_Air_France;
INSERT INTO T_vols_historique_vlh
(vlh_num_vol,vlh_creation,vlh_fin_exploitation,vlh_h_dep,vlh_h_arr,aer_dep,aer_arr)
VALUES 
 ('AF441',DATEFROMPARTS(1990,05,13),
          DATETIME2FROMPARTS(2010,12,28,10,45,0,0,0),
          TIMEFROMPARTS(23,30,0,0,0),TIMEFROMPARTS(6,0,0,0,0),'CDG','GIG');

UPDATE  T_vols_historique_vlh
SET     vlh_creation = DATEFROMPARTS(1990,04,10)
WHERE   vlh_num_vol  = 'AF441';

UPDATE  T_vols_historique_vlh
SET     vlh_fin_exploitation = DATEADD(month,3,vlh_fin_exploitation)
WHERE   vlh_num_vol          = 'AF6145';

UPDATE  T_vols_historique_vlh
SET     vlh_h_arr   = DATEADD(minute,-15,vlh_h_arr)
WHERE   vlh_num_vol = 'AF6140';


-- 191, autres fct

SELECT EOMONTH(DATEFROMPARTS(2012,02,21)) AS 'Fvrier 2012',
       EOMONTH('2012-02-21 01:18:58',12)  AS 'Fvrier 2013',
       EOMONTH('20120221',          -12 ) AS 'Fvrier 2011';

DECLARE @d1 DATETIMEOFFSET;
SET     @d1 = DATETIMEOFFSETFROMPARTS(2014,02,05,7,33,45,0,+5,0,0);
SELECT  @d1 AS "Avant";
SET     @d1 = SWITCHOFFSET(@d1,'-01:00');
SELECT  @d1 AS "Aprs";	

DECLARE @d1   DATETIME2(3);
DECLARE @d2   DATETIMEOFFSET(3);
SET     @d1 = DATETIME2FROMPARTS (2012,12,05,6,30,0,276,3);
SELECT  @d1 AS "Avant";
SET     @d2 = TODATETIMEOFFSET(@d1,'+10:00');
SELECT  @d2 AS "Aprs";	

DECLARE @d1   DATE;
DECLARE @t1   TIME;
SET     @d1 = DATEFROMPARTS(2012,15,15);

SET    DATEFORMAT DMY;
SELECT ISDATE('13/05/1995') AS "13/05/1995", ISDATE('19950513') AS "19950513",
       ISDATE('2012/12/14') AS "2012/12/14", ISDATE('2012/14/14') AS "2012/14/14";

SET    DATEFORMAT YMD;
SELECT ISDATE('2012/12/14') AS "2012/12/14", ISDATE('2012/14/14') AS "2012/14/14";

SELECT ISDATE('20:30:59') AS "20:30:59",ISDATE('20:30:60') AS "20:30:60",
       ISDATE('0:0:0') AS "0:0:0",ISDATE('10:70:00') AS "10:70:00";

DECLARE @d DATETIME2 = GETDATE();
SELECT FORMAT( @d,'d','en-US' ) AS "Date US",FORMAT( @d,'d','fr-FR' ) AS "Date FR";
SELECT FORMAT( @d,'dddd dd MMMM, yyyy hh \h. mm \min. ss \sec. fff \milli.') AS "Maintenant";


-- nettoyage

IF OBJECT_ID ('dbo.T_heures_heu','U') IS NOT NULL
    DROP TABLE dbo.T_heures_heu;
GO

IF OBJECT_ID ('dbo.T_le_changement_c_maintenant','U') IS NOT NULL
    DROP TABLE dbo.T_le_changement_c_maintenant;
GO

IF OBJECT_ID ('dbo.T_vols_historique_vlh','U') IS NOT NULL
    DROP TABLE dbo.T_vols_historique_vlh;
GO
IF OBJECT_ID ('dbo.T_date_naissance_dat','U') IS NOT NULL
    DROP TABLE dbo.T_date_naissance_dat;
GO
